/*
 * Decompiled with CFR 0.152.
 */
package vectorwing.farmersdelight.data;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.DoublePlantBlock;
import net.minecraft.block.RotatedPillarBlock;
import net.minecraft.data.DataGenerator;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.VariantBlockStateBuilder;
import net.minecraftforge.common.data.ExistingFileHelper;
import vectorwing.farmersdelight.blocks.BasketBlock;
import vectorwing.farmersdelight.blocks.CabbagesBlock;
import vectorwing.farmersdelight.blocks.FeastBlock;
import vectorwing.farmersdelight.blocks.MushroomColonyBlock;
import vectorwing.farmersdelight.blocks.OnionsBlock;
import vectorwing.farmersdelight.blocks.PantryBlock;
import vectorwing.farmersdelight.blocks.PieBlock;
import vectorwing.farmersdelight.blocks.RiceUpperCropBlock;
import vectorwing.farmersdelight.blocks.StoveBlock;
import vectorwing.farmersdelight.blocks.TomatoesBlock;
import vectorwing.farmersdelight.registry.ModBlocks;

public class BlockStates
extends BlockStateProvider {
    private static final int DEFAULT_ANGLE_OFFSET = 180;

    public BlockStates(DataGenerator gen, ExistingFileHelper exFileHelper) {
        super(gen, "farmersdelight", exFileHelper);
    }

    private String blockName(Block block) {
        return block.getRegistryName().func_110623_a();
    }

    public ResourceLocation resourceBlock(String path) {
        return new ResourceLocation("farmersdelight", "block/" + path);
    }

    public ModelFile existingModel(Block block) {
        return new ModelFile.ExistingModelFile(this.resourceBlock(this.blockName(block)), this.models().existingFileHelper);
    }

    public ModelFile existingModel(String path) {
        return new ModelFile.ExistingModelFile(this.resourceBlock(path), this.models().existingFileHelper);
    }

    protected void registerStatesAndModels() {
        this.simpleBlock((Block)ModBlocks.RICH_SOIL.get(), this.cubeRandomRotation((Block)ModBlocks.RICH_SOIL.get(), ""));
        this.simpleBlock((Block)ModBlocks.SAFETY_NET.get(), this.existingModel((Block)ModBlocks.SAFETY_NET.get()));
        String riceBag = this.blockName((Block)ModBlocks.RICE_BAG.get());
        this.simpleBlock((Block)ModBlocks.RICE_BAG.get(), (ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(riceBag, "cube")).texture("particle", this.resourceBlock(riceBag + "_top"))).texture("down", this.resourceBlock(riceBag + "_bottom"))).texture("up", this.resourceBlock(riceBag + "_top"))).texture("north", this.resourceBlock(riceBag + "_side_tied"))).texture("south", this.resourceBlock(riceBag + "_side_tied"))).texture("east", this.resourceBlock(riceBag + "_side"))).texture("west", this.resourceBlock(riceBag + "_side")));
        this.customDirectionalBlock((Block)ModBlocks.BASKET.get(), $ -> this.existingModel((Block)ModBlocks.BASKET.get()), new Property[]{BasketBlock.ENABLED, BasketBlock.WATERLOGGED});
        this.customDirectionalBlock((Block)ModBlocks.RICE_BALE.get(), $ -> this.existingModel((Block)ModBlocks.RICE_BALE.get()), new Property[0]);
        this.customHorizontalBlock((Block)ModBlocks.CUTTING_BOARD.get(), $ -> this.existingModel((Block)ModBlocks.CUTTING_BOARD.get()), new Property[]{BasketBlock.WATERLOGGED});
        this.horizontalBlock((Block)ModBlocks.HALF_TATAMI_MAT.get(), this.existingModel("tatami_mat_half"));
        this.horizontalBlock((Block)ModBlocks.STOVE.get(), state -> {
            String name = this.blockName((Block)ModBlocks.STOVE.get());
            String suffix = (Boolean)state.func_177229_b((Property)StoveBlock.LIT) != false ? "_on" : "";
            return this.models().orientableWithBottom(name + suffix, this.resourceBlock(name + "_side"), this.resourceBlock(name + "_front" + suffix), this.resourceBlock(name + "_bottom"), this.resourceBlock(name + "_top" + suffix));
        });
        this.stageBlock((Block)ModBlocks.BROWN_MUSHROOM_COLONY.get(), MushroomColonyBlock.COLONY_AGE, new Property[0]);
        this.stageBlock((Block)ModBlocks.RED_MUSHROOM_COLONY.get(), MushroomColonyBlock.COLONY_AGE, new Property[0]);
        this.stageBlock((Block)ModBlocks.RICE_UPPER_CROP.get(), RiceUpperCropBlock.RICE_AGE, new Property[0]);
        this.customStageBlock((Block)ModBlocks.CABBAGE_CROP.get(), this.resourceBlock("crop_cross"), "cross", CabbagesBlock.field_176488_a, new ArrayList<Integer>(), new Property[0]);
        this.customStageBlock((Block)ModBlocks.TOMATO_CROP.get(), this.resourceBlock("crop_cross"), "cross", TomatoesBlock.AGE, Arrays.asList(0, 0, 1, 1, 2, 2, 3, 4), new Property[0]);
        this.customStageBlock((Block)ModBlocks.ONION_CROP.get(), this.mcLoc("crop"), "crop", OnionsBlock.field_176488_a, Arrays.asList(0, 0, 1, 1, 2, 2, 2, 3), new Property[0]);
        this.crateBlock((Block)ModBlocks.CARROT_CRATE.get(), "carrot");
        this.crateBlock((Block)ModBlocks.POTATO_CRATE.get(), "potato");
        this.crateBlock((Block)ModBlocks.BEETROOT_CRATE.get(), "beetroot");
        this.crateBlock((Block)ModBlocks.CABBAGE_CRATE.get(), "cabbage");
        this.crateBlock((Block)ModBlocks.TOMATO_CRATE.get(), "tomato");
        this.crateBlock((Block)ModBlocks.ONION_CRATE.get(), "onion");
        this.axisBlock((RotatedPillarBlock)ModBlocks.STRAW_BALE.get());
        this.pantryBlock((Block)ModBlocks.OAK_PANTRY.get(), "oak");
        this.pantryBlock((Block)ModBlocks.BIRCH_PANTRY.get(), "birch");
        this.pantryBlock((Block)ModBlocks.SPRUCE_PANTRY.get(), "spruce");
        this.pantryBlock((Block)ModBlocks.JUNGLE_PANTRY.get(), "jungle");
        this.pantryBlock((Block)ModBlocks.ACACIA_PANTRY.get(), "acacia");
        this.pantryBlock((Block)ModBlocks.DARK_OAK_PANTRY.get(), "dark_oak");
        this.pantryBlock((Block)ModBlocks.CRIMSON_PANTRY.get(), "crimson");
        this.pantryBlock((Block)ModBlocks.WARPED_PANTRY.get(), "warped");
        this.pieBlock((Block)ModBlocks.APPLE_PIE.get());
        this.pieBlock((Block)ModBlocks.CHOCOLATE_PIE.get());
        this.pieBlock((Block)ModBlocks.SWEET_BERRY_CHEESECAKE.get());
        this.feastBlock((FeastBlock)ModBlocks.STUFFED_PUMPKIN_BLOCK.get());
        this.feastBlock((FeastBlock)ModBlocks.ROAST_CHICKEN_BLOCK.get());
        this.feastBlock((FeastBlock)ModBlocks.HONEY_GLAZED_HAM_BLOCK.get());
        this.feastBlock((FeastBlock)ModBlocks.SHEPHERDS_PIE_BLOCK.get());
        this.wildCropBlock((Block)ModBlocks.WILD_BEETROOTS.get(), false);
        this.wildCropBlock((Block)ModBlocks.WILD_CABBAGES.get(), false);
        this.wildCropBlock((Block)ModBlocks.WILD_POTATOES.get(), false);
        this.wildCropBlock((Block)ModBlocks.WILD_TOMATOES.get(), false);
        this.wildCropBlock((Block)ModBlocks.WILD_CARROTS.get(), true);
        this.wildCropBlock((Block)ModBlocks.WILD_ONIONS.get(), true);
        this.doublePlantBlock((Block)ModBlocks.WILD_RICE.get());
    }

    public ConfiguredModel[] cubeRandomRotation(Block block, String suffix) {
        String formattedName = this.blockName(block) + (suffix.isEmpty() ? "" : "_" + suffix);
        return ConfiguredModel.allYRotations((ModelFile)this.models().cubeAll(formattedName, this.resourceBlock(formattedName)), (int)0, (boolean)false);
    }

    public void customDirectionalBlock(Block block, Function<BlockState, ModelFile> modelFunc, Property<?> ... ignored) {
        this.getVariantBuilder(block).forAllStatesExcept(state -> {
            Direction dir = (Direction)state.func_177229_b((Property)BlockStateProperties.field_208155_H);
            return ConfiguredModel.builder().modelFile((ModelFile)modelFunc.apply((BlockState)state)).rotationX(dir == Direction.DOWN ? 180 : (dir.func_176740_k().func_176722_c() ? 90 : 0)).rotationY(dir.func_176740_k().func_200128_b() ? 0 : ((int)dir.func_185119_l() + 180) % 360).build();
        }, ignored);
    }

    public void customHorizontalBlock(Block block, Function<BlockState, ModelFile> modelFunc, Property<?> ... ignored) {
        this.getVariantBuilder(block).forAllStatesExcept(state -> ConfiguredModel.builder().modelFile((ModelFile)modelFunc.apply((BlockState)state)).rotationY(((int)((Direction)state.func_177229_b((Property)BlockStateProperties.field_208157_J)).func_185119_l() + 180) % 360).build(), ignored);
    }

    public void stageBlock(Block block, IntegerProperty ageProperty, Property<?> ... ignored) {
        this.getVariantBuilder(block).forAllStatesExcept(state -> {
            int ageSuffix = (Integer)state.func_177229_b((Property)ageProperty);
            String stageName = this.blockName(block) + "_stage" + ageSuffix;
            return ConfiguredModel.builder().modelFile((ModelFile)this.models().cross(stageName, this.resourceBlock(stageName))).build();
        }, ignored);
    }

    public void customStageBlock(Block block, @Nullable ResourceLocation parent, String textureKey, IntegerProperty ageProperty, List<Integer> suffixes, Property<?> ... ignored) {
        this.getVariantBuilder(block).forAllStatesExcept(state -> {
            int ageSuffix = (Integer)state.func_177229_b((Property)ageProperty);
            String stageName = this.blockName(block) + "_stage";
            stageName = stageName + (suffixes.isEmpty() ? ageSuffix : (Integer)suffixes.get(Math.min(suffixes.size(), ageSuffix)));
            if (parent == null) {
                return ConfiguredModel.builder().modelFile((ModelFile)this.models().cross(stageName, this.resourceBlock(stageName))).build();
            }
            return ConfiguredModel.builder().modelFile((ModelFile)this.models().singleTexture(stageName, parent, textureKey, this.resourceBlock(stageName))).build();
        }, ignored);
    }

    public void wildCropBlock(Block block, boolean isBushCrop) {
        if (isBushCrop) {
            this.simpleBlock(block, (ModelFile)this.models().singleTexture(this.blockName(block), this.resourceBlock("bush_crop"), "crop", this.resourceBlock(this.blockName(block))));
        } else {
            this.simpleBlock(block, (ModelFile)this.models().cross(this.blockName(block), this.resourceBlock(this.blockName(block))));
        }
    }

    public void crateBlock(Block block, String cropName) {
        this.simpleBlock(block, (ModelFile)this.models().cubeBottomTop(this.blockName(block), this.resourceBlock(cropName + "_crate_side"), this.resourceBlock("crate_bottom"), this.resourceBlock(cropName + "_crate_top")));
    }

    public void pantryBlock(Block block, String woodType) {
        this.horizontalBlock(block, state -> {
            String suffix = (Boolean)state.func_177229_b((Property)PantryBlock.OPEN) != false ? "_open" : "";
            return this.models().orientable(this.blockName(block) + suffix, this.resourceBlock(woodType + "_pantry_side"), this.resourceBlock(woodType + "_pantry_front" + suffix), this.resourceBlock(woodType + "_pantry_top"));
        });
    }

    public void feastBlock(FeastBlock block) {
        this.getVariantBuilder(block).forAllStates(state -> {
            int servings = (Integer)state.func_177229_b((Property)FeastBlock.SERVINGS);
            String suffix = "_stage" + (block.getMaxServings() - servings);
            if (servings == 0) {
                suffix = block.hasLeftovers ? "_leftover" : "_stage3";
            }
            return ConfiguredModel.builder().modelFile(this.existingModel(this.blockName(block) + suffix)).rotationY(((int)((Direction)state.func_177229_b((Property)FeastBlock.FACING)).func_185119_l() + 180) % 360).build();
        });
    }

    public void doublePlantBlock(Block block) {
        ((VariantBlockStateBuilder)this.getVariantBuilder(block).partialState().with((Property)DoublePlantBlock.field_176492_b, (Comparable)DoubleBlockHalf.LOWER).modelForState().modelFile((ModelFile)this.models().cross(this.blockName(block) + "_bottom", this.resourceBlock(this.blockName(block) + "_bottom"))).addModel()).partialState().with((Property)DoublePlantBlock.field_176492_b, (Comparable)DoubleBlockHalf.UPPER).modelForState().modelFile((ModelFile)this.models().cross(this.blockName(block) + "_top", this.resourceBlock(this.blockName(block) + "_top"))).addModel();
    }

    public void pieBlock(Block block) {
        this.getVariantBuilder(block).forAllStates(state -> {
            int bites = (Integer)state.func_177229_b((Property)PieBlock.BITES);
            String suffix = bites > 0 ? "_slice" + bites : "";
            return ConfiguredModel.builder().modelFile(this.existingModel(this.blockName(block) + suffix)).rotationY(((int)((Direction)state.func_177229_b((Property)PieBlock.FACING)).func_185119_l() + 180) % 360).build();
        });
    }
}

